const scene = new THREE.Scene();

const camera = new THREE.PerspectiveCamera(
	75,
	window.innerWidth / window.innerHeight,
	1,
	1000
);

camera.position.z = 100;
const canvas = document.getElementById("canvas");
const renderer = new THREE.WebGLRenderer({ antilias: true });
renderer.setClearColor("#D1E7DD");
renderer.setSize((window.innerWidth * 75) / 100, window.innerHeight);
renderer.setPixelRatio(devicePixelRatio);
canvas.appendChild(renderer.domElement);

// declare controls to move object vertically
const controls = new THREE.OrbitControls(camera, renderer.domElement);

//make canvas responsive
window.addEventListener("resize", () => {
	camera.aspect = window.innerWidth / window.innerHeight;
	camera.updateProjectionMatrix();
	renderer.setSize((window.innerWidth * 75) / 100, window.innerHeight);
});

let textGeometry;
let material;
let mesh;
let textureMesh;
let doubleMesh;
let doubleMaterial;
let doubleText;
let texture;

let fontFamily = "optimer";
let fontWeight = "regular";
let size = 60;
let height = 1.9;
let position = 0;
let color = new THREE.Color(0x3399ff);
let colorDouble = new THREE.Color(0x3399ff);
let text = "";
let image = "";
const loader = new THREE.FontLoader();
const textureLoader = new THREE.TextureLoader();

function addText(fontFamily, fontWeight, text, color, size, height, position) {
	loader.load(`fonts/${fontFamily}_${fontWeight}.json`, function (font) {
		textGeometry = new THREE.TextGeometry(text, {
			font: font,
			size: size,
			height: height,
			curveSegments: 50,
			bevelEnabled: false,
			bevelThickness: 10,
			bevelSize: 8,
			bevelOffset: 0,
			bevelSegments: 5,
		});
		material = new THREE.MeshLambertMaterial({ color: color });
		mesh = new THREE.Mesh(textGeometry, material);

		// align text center
		textGeometry.computeBoundingBox();
		textGeometry.center();
		mesh.geometry.dispose();
		mesh.geometry = textGeometry;
		mesh.position.setZ(position);
		scene.add(mesh);
	});
}

function addDoubleText(
	fontFamily,
	fontWeight,
	text,
	color,
	size,
	height,
	position
) {
	loader.load(`fonts/${fontFamily}_${fontWeight}.json`, function (font) {
		doubleText = new THREE.TextGeometry(text, {
			font: font,
			size: size,
			height: height,
			curveSegments: 50,
			bevelEnabled: false,
			bevelThickness: 10,
			bevelSize: 8,
			bevelOffset: 0,
			bevelSegments: 5,
		});
		doubleMaterial = new THREE.MeshLambertMaterial({ color: color });
		doubleMesh = new THREE.Mesh(doubleText, doubleMaterial);

		// align text center
		doubleText.computeBoundingBox();
		doubleText.center();
		doubleMesh.geometry.dispose();
		doubleMesh.geometry = doubleText;
		doubleMesh.position.setZ(position);
		scene.add(doubleMesh);
	});
}

function loadImage(image) {
	if (image !== "") {
		texture = textureLoader.load(image);
		texture.wrapS = THREE.RepeatWrapping;
		texture.wrapT = THREE.RepeatWrapping;
		texture.repeat.set(0.01, 0.01);
		textureMaterial = new THREE.MeshPhongMaterial({ map: texture });
		textureMesh = new THREE.Mesh(textGeometry, textureMaterial);
		scene.add(textureMesh);
	}
}

// const sphere = new THREE.SphereGeometry( 40, 30, 30 );
// const textureEarth = textureLoader.load('./textures/earth.png')
// const materialEarth = new THREE.MeshPhongMaterial({map: textureEarth})
// const meshEarth = new THREE.Mesh(sphere, materialEarth)
// meshEarth.position.set(-60,0,0)
// scene.add(meshEarth)

// Add shadow to object
const light = new THREE.PointLight(0xffffff, 1, 500);
light.position.set(0, 10, 90);
scene.add(light);

const spotLight = new THREE.SpotLight(0xffffff);
spotLight.position.set(100, 1000, 100);

spotLight.castShadow = true;

spotLight.shadow.mapSize.width = 1024;
spotLight.shadow.mapSize.height = 1024;

spotLight.shadow.camera.near = 500;
spotLight.shadow.camera.far = 4000;
spotLight.shadow.camera.fov = 30;

scene.add(spotLight);

const AmbientLight = new THREE.AmbientLight(0x404040); // soft white light
scene.add(AmbientLight);

// addText(fontFamily, fontWeight, text, color, size, height, 0);

// addText(fontFamily, fontWeight, text, '#cccccc', size, height, 35)

const stats = new Stats();
const animate = () => {
	controls.update();
	stats.update();
	requestAnimationFrame(animate);
	renderer.render(scene, camera);
};

const fontSelect = document.getElementById("fontSelect");
const selectWeight = document.getElementById("selectWeight");
const inputText = document.getElementById("inputText");
const valider = document.getElementById("valider");
let largeur = document.getElementById("largeur");
let longueur = document.getElementById("longueur");
let myRange = document.getElementById("myRange");
let price = document.getElementById("price");
let inputColor = document.getElementById("inputColor");
let inputColor_double = document.getElementById("inputColor_double");
let textureSelect = document.getElementById("textureSelect");

// change font
fontSelect.addEventListener("change", function () {
	fontFamily = this.value;
	removeMesh();
	image = "";
	if (radioValue === "double") {
		addText(fontFamily, fontWeight, text, color, size, height, 0);
		addDoubleText(
			fontFamily,
			fontWeight,
			text,
			color,
			size,
			height,
			height
		);
	} else {
		addText(fontFamily, fontWeight, text, color, size, height, position);
		loadImage(image);
	}
});

//change weight
selectWeight.addEventListener("change", function () {
	fontWeight = this.value;
	removeMesh();
	image = "";
	if (radioValue === "double") {
		addText(fontFamily, fontWeight, text, color, size, height, 0);
		addDoubleText(
			fontFamily,
			fontWeight,
			text,
			color,
			size,
			height,
			height
		);
	} else {
		addText(fontFamily, fontWeight, text, color, size, height, position);
		loadImage(image);
	}
});

// change color
inputColor.addEventListener("change", function () {
	color = new THREE.Color(this.value);

	image = "";
	if (radioValue === "double") {
		addText(fontFamily, fontWeight, text, color, size, height, 0);
		addDoubleText(
			fontFamily,
			fontWeight,
			text,
			color,
			size,
			height,
			-height
		);
	} else {
		addText(fontFamily, fontWeight, text, color, size, height, position);
	}
});

inputColor_double.addEventListener("change", function () {
	colorDouble = new THREE.Color(this.value);
	image = "";
	addDoubleText(fontFamily, fontWeight, text, colorDouble, size, height, height);
});

// clear text
inputText.addEventListener("click", function () {
	this.value = "";
	text = "";
	isDisabled();
	price.textContent = "";
	removeMesh();
});

function removeMesh() {
	for (let i = scene.children.length - 1; i >= 0; i--) {
		if (scene.children[i].type === "Mesh") scene.remove(scene.children[i]);
	}
}

inputText.addEventListener("keyup", function () {
	text = this.value;
	inputText.value = this.value;
	isDisabled();
});

inputText.addEventListener("focusout", function () {
	if (radioValue === "simple")
		addText(fontFamily, fontWeight, text, color, size, height, 0);
	if (radioValue === "double") {
		addText(fontFamily, fontWeight, text, color, size, height, 0);
		addDoubleText(
			fontFamily,
			fontWeight,
			text,
			color,
			size,
			height,
			height
		);
	}
});

// Afficher le prix selon la largeur et le longueur et le nombre de lettres
document.getElementById("getPrice").addEventListener("click", () => {
	console.log(text.length, size, height);
	price.textContent = (text.length * size * height).toFixed(2) + "€";
	price.style.display = "inherit";
});

let radioValue = "";
// Simple support selected
document
	.getElementById("simple_support")
	.addEventListener("click", function () {
		removeMesh();
		document.getElementById("div_double_support").style.display = "none";
		document.getElementById("div_simple_support").style.display = "block";
		radioValue = this.value;
		console.log(radioValue);
		isDisabled();
	});

// Double support selected
document
	.getElementById("double_support")
	.addEventListener("click", function () {
		removeMesh();
		addText(fontFamily, fontWeight, text, color, size, height, 0);
		document.getElementById("div_double_support").style.display = "block";
		document.getElementById("div_simple_support").style.display = "none";
		radioValue = this.value;
		console.log(radioValue);
		isDisabled();
	});

// function to activate validation button
function isDisabled() {
	if (inputText.value === "" || radioValue === "") {
		valider.disabled = true;
	} else {
		valider.disabled = false;
	}
}

let type_support;

let select_simple_support = document.getElementById("select_simple_support");

select_simple_support.addEventListener("change", function () {
	if (this.value === "lichen") {
		document.getElementById("lichen").style.display = "block";
		document.getElementById("bois").style.display = "none";
		document.getElementById("pvc").style.display = "none";
		document.getElementById("color_palette").style.display = "none";
		document.getElementById("metal_miroir").style.display = "none";
		document.getElementById("polystyrene").style.display = "none";
	} else if (this.value === "bois") {
		document.getElementById("lichen").style.display = "none";
		document.getElementById("bois").style.display = "block";
		document.getElementById("pvc").style.display = "none";
		document.getElementById("color_palette").style.display = "none";
		document.getElementById("metal_miroir").style.display = "none";
		document.getElementById("polystyrene").style.display = "none";
	} else if (this.value === "pvc") {
		document.getElementById("lichen").style.display = "none";
		document.getElementById("bois").style.display = "none";
		document.getElementById("pvc").style.display = "block";
		document.getElementById("color_palette").style.display = "none";
		document.getElementById("metal_miroir").style.display = "none";
		document.getElementById("polystyrene").style.display = "none";
	} else if (this.value === "plexy" || this.value === "vinyle") {
		removeMesh();
		height = 0.6;
		addText(fontFamily, fontWeight, text, color, size, height, 0);

		document.getElementById("lichen").style.display = "none";
		document.getElementById("bois").style.display = "none";
		document.getElementById("pvc").style.display = "none";
		document.getElementById("color_palette").style.display = "block";
		document.getElementById("metal_miroir").style.display = "none";
		document.getElementById("polystyrene").style.display = "none";
	} else if (this.value === "metal_miroir") {
		document.getElementById("lichen").style.display = "none";
		document.getElementById("bois").style.display = "none";
		document.getElementById("pvc").style.display = "none";
		document.getElementById("color_palette").style.display = "none";
		document.getElementById("metal_miroir").style.display = "block";
		document.getElementById("polystyrene").style.display = "none";
	} else if (this.value === "polystyrene") {
		document.getElementById("lichen").style.display = "none";
		document.getElementById("bois").style.display = "none";
		document.getElementById("pvc").style.display = "none";
		document.getElementById("color_palette").style.display = "block";
		document.getElementById("metal_miroir").style.display = "none";
		document.getElementById("polystyrene").style.display = "block";
	}
});

document.getElementById("lichen").addEventListener("change", function () {
	valider.disabled = false;
	removeMesh();
	height = 1.9;
	addText(fontFamily, fontWeight, text, color, size, height, 0);
	image = `../textures/${this.value}.png`;
	loadImage(image);
});

document.getElementById("bois").addEventListener("change", function () {
	valider.disabled = false;
	removeMesh();
	height = 1.9;
	addText(fontFamily, fontWeight, text, color, size, height, 0);
	image = `../textures/${this.value}.png`;
	loadImage(image);
});

document.getElementById("pvc").addEventListener("change", function () {
	color = this.value;
	height = 1.9;
	removeMesh();
	addText(fontFamily, fontWeight, text, color, size, height, 0);
});
document.getElementById("metal_miroir").addEventListener("change", function () {
	valider.disabled = false;
	type_support = this.value;
	removeMesh();
	image = `../textures/${this.value}.png`;
	loadImage(image);
});
document.getElementById("polystyrene").addEventListener("change", function () {
	height = this.value;
	removeMesh();
	addDoubleText(fontFamily, fontWeight, text, color, size, height, 0);
});

// valider.addEventListener("click", function () {
// 	if (
// 		select_simple_support.value === "lichen" ||
// 		select_simple_support.value === "metal_miroir" ||
// 		select_simple_support.value === "bois"
// 	) {
// 		image = `../textures/${type_support}.png`;
// 		loadImage(image);
// 	} else if (
// 		select_simple_support.value === "pvc" ||
// 		select_simple_support.value === "plexy" ||
// 		select_simple_support.value === "vinyle" ||
// 		select_simple_support.value === "polystyrene"
// 	) {
// 		image = "";
// 		height = 1.9;
// 		removeMesh()
// 		addText(fontFamily, fontWeight, text, color, size, height, 0);
// 	}
// 	valider.disabled = true;
// });

// document.getElementById("valider_arr").addEventListener("click", function () {
// 	//removeMesh()
// 	addText(fontFamily, fontWeight, text, color, size, height, 0);
// 	// image = "../textures/metal_brosse_or.png";
// 	// loadImage("../textures/metal_brosse_or.png");
// });

// document.getElementById("valider_ava").addEventListener("click", function () {
// 	removeMesh()
// 	console.log(scene.children)
// 	addDoubleText(fontFamily, fontWeight, text, color, size, height, -height);
// 	image = "../textures/miroir.png";
// 	loadImage("../textures/miroir.png");
// });

document.getElementById("support_arr").addEventListener("change", function () {
	removeMesh();
	color = this.value;
	addText(fontFamily, fontWeight, text, color, size, height, 0);
});

document.getElementById("support_ava").addEventListener("change", function () {
	if (this.value === "plexy") {
		removeMesh();
		addText(fontFamily, fontWeight, text, color, size, height, 0);
		document.getElementById("color_double").style.display = "block";
	} else {
		document.getElementById("color_double").style.display = "none";
		removeMesh();
		image = `../textures/${this.value}.png`;
		addDoubleText(
			fontFamily,
			fontWeight,
			text,
			color,
			size,
			height,
			-height
		);
		loadImage(image);
	}
});

animate();
