<?php

namespace App\Controller;

use App\Entity\Parrain;
use App\Form\RegistrationFormTypeParrain;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class ParrainController extends AbstractController
{
    /**
     * @Route("/parrain", name="parrain")
     */
    public function register(Request $request, UserPasswordEncoderInterface $passwordEncoder)
    {
        $parrain = new Parrain();
        $form = $this->createForm(RegistrationFormTypeParrain::class, $parrain);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // encode the plain password
            $parrain->setPassword(
                $passwordEncoder->encodePassword(
                    $parrain,
                    $form->get('plainPassword')->getData()
                )
            );

            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($parrain);
            $entityManager->flush();

            // do anything else you need here, like send an email

            return $this->redirectToRoute('accueil');
        }

        return $this->render('parrain/index.html.twig', [
            'registrationForm' => $form->createView(),
        ]);
    }
}
