<?php

namespace App\Controller;

use App\Repository\OffreRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class OffresController extends AbstractController
{
    /**
     * @Route("/offres", name="offres")
     */
    public function index(OffreRepository $offreRepository)
    {
        return $this->render('offres/index.html.twig', [
            'offres' => $offreRepository->findAll(),
        ]);
    }

    /**
     * @Route("/search", name="search")
     */
    public function recherche(OffreRepository $offreRepository, Request $request)
    {
        // $search = $request->get('search');
        // $offre = $offreRepository->findBy(['MotCle'=>$search]);

        // return $this->render('offres/index.html.twig', [
        //     'offres' => $offre,
        // ]);

        // return $this->render('offres/index.html.twig', [
        //     'offres' => $offreRepository->findBy(['MotCle'=>$request->get('search')]),
        // ]);

       $search = '%'.$request->get('search').'%';
        $result = $offreRepository->createQueryBuilder('o')
            ->where('o.MotCle LIKE :motcle')
            ->setParameter('motcle', $search)
            ->getQuery()
            ->getResult();

        return $this->render('offres/index.html.twig', [
            'offres' => $result,
        ]);
    }
}
