<?php

namespace App\Controller;

use App\Entity\Entreprise;
use App\Form\RegistrationFormTypeEntreprise;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class EntrepriseController extends AbstractController
{
    /**
     * @Route("/entreprise", name="entreprise")
     */
    public function register(Request $request, UserPasswordEncoderInterface $passwordEncoder)
    {
        $entreprise = new Entreprise();
        $form = $this->createForm(RegistrationFormTypeEntreprise::class, $entreprise);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // encode the plain password
            $entreprise->setPassword(
                $passwordEncoder->encodePassword(
                    $entreprise,
                    $form->get('plainPassword')->getData()
                )
            );

            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($entreprise);
            $entityManager->flush();

            // do anything else you need here, like send an email

            return $this->redirectToRoute('accueil');
        }

        return $this->render('entreprise/index.html.twig', [
            'registrationForm' => $form->createView(),
        ]);
    }
}
