<?php

namespace App\Controller;

use App\Entity\Candidat;
use App\Form\RegistrationFormTypeCandidat;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class CandidatController extends AbstractController
{
   /**
     * @Route("/candidat", name="candidat")
     */
    public function register(Request $request, UserPasswordEncoderInterface $passwordEncoder)
    {
        $candidat = new Candidat();
        $form = $this->createForm(RegistrationFormTypeCandidat::class, $candidat);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // encode the plain password
            $candidat->setPassword(
                $passwordEncoder->encodePassword(
                    $candidat,
                    $form->get('plainPassword')->getData()
                )
            );

            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($candidat);
            $entityManager->flush();

            // do anything else you need here, like send an email

            return $this->redirectToRoute('accueil');
        }

        return $this->render('candidat/index.html.twig', [
            'registrationForm' => $form->createView(),
        ]);
    }
}
