<?php

namespace App\Controller;

use App\Entity\Admin;
use App\Entity\Article;
use App\Entity\Offre;
use App\Form\ArticleType;
use App\Form\OffreType;
use App\Form\RegistrationFormTypeAdmin;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

/**
 * @Route("/admin")
 * @IsGranted("ROLE_ADMIN")
 */
class AdminController extends AbstractController
{
    /**
     * @Route("/membres", name="admin_index")
     */
    public function register(Request $request, UserPasswordEncoderInterface $passwordEncoder)
    {
        $admin = new Admin();
        $form = $this->createForm(RegistrationFormTypeAdmin::class, $admin);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            // encode the plain password
            $admin->setPassword(
                $passwordEncoder->encodePassword(
                    $admin,
                    $form->get('plainPassword')->getData()
                )
            );
            $admin->setRoles(['ROLE_ADMIN']);

            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($admin);
            $entityManager->flush();

            // do anything else you need here, like send an email

            return $this->redirectToRoute('accueil');
        }

        return $this->render('membres/index.html.twig', [
            'registrationForm' => $form->createView(),
        ]);
    }

    /**
     * @Route("/contenu", name="contenu", methods={"GET","POST"})
     */
    public function new(Request $request): Response
    {
        $article = new Article();
        $formArticle = $this->createForm(ArticleType::class, $article);
        $formArticle->handleRequest($request);

        $offre = new Offre();
        $formOffre = $this->createForm(OffreType::class, $offre);
        $formOffre->handleRequest($request);


        if (($formArticle->isSubmitted() && $formArticle->isValid()) || 
        ($formOffre->isSubmitted() && $formOffre->isValid())) {
            $entityManager = $this->getDoctrine()->getManager();
            $objet = null;
            if ($formArticle->isSubmitted() && $formArticle->isValid()) {
                $objet = $article;
            }else{
                $objet = $offre;
            }
            $entityManager->persist($objet);
            $entityManager->flush();

            return $this->redirectToRoute('admin_index');
        }

        return $this->render('contenu/index.html.twig', [
            // 'article' => $article,
            'formArticle' => $formArticle->createView(),
            'formOffre' => $formOffre->createView(),
        ]);
    }

    



}
