//========================== NOTES ==============================

// Affichage des notes de la page
window.onload = function(e){ 

    let divnotes = document.getElementById("sidenotes");
    let btnright = document.getElementById("notesright");
    let btnleft  = document.getElementById("notesleft");
    let notesnew = document.getElementById("notesnew");
    let hiduserid = document.getElementById("notesuserid");
    let noteErr  = document.getElementById("noteErr");
    noteErr.style.display = "none";

    //extraction de la route relative 
    let root = location.protocol + '//' + location.host;       
    let route = window.location.href;
    route = route.substr(root.length);  
    //remplace les méthodes CRUD par * pour globaliser les notes sur un item spécfique
    const regex = /\b(show|edit)\b/;
    route = route.replace(regex, '*'); 

    if(divnotes != null) {      
        //recup des notes pour la route
        let url = root + "/note/list/" + fixedEncodeURI(route); 
        fetch(url)
        .then(resp => resp.json())
        .then(data => {
        afficherNotes(data); 
        });
    }

    function afficherNotes( notes ) {    
        //affiche le sidebar que pour des notes existantes
        if( notes.length <1) {
        collapseOffNotes();
        return;
        };
        collapseOnNotes();
    
        //affiche chaque note
        notes.forEach(note => {
            let div = getDivNote(note);
            divnotes.appendChild(div);
        });    
    }

    function getDivNote( note ) {    
        let div = document.createElement("div");
        div.id = "note_" + note.id;
        div.setAttribute("class", "note");
        let html='<img src="'+root+'/uploads/avatars/'+note.auteur.avatar+'" title="'+note.auteur.Username+'" class="avatar-rond" />' +
                 '<div>' +note.texte + '</div>';
        if(hiduserid.value == note.auteur.id) {
            html += '<a nohref onclick="deleteNote('+note.id+')"><i class="fa fa-times"></i></a>';
        }
        html += '<p>' + note.createdStr + '</p>';
        div.innerHTML = html;
        return div;
    }
    
    //affiche ou non le panneau des notes
    function collapseOffNotes() {
        divnotes.setAttribute("class", "notes-inactive");
        btnright.style.display = "none";
        btnleft.style.display = "block";
    };
    function collapseOnNotes() {
        divnotes.setAttribute("class", "notes-active");  
        btnright.style.display = "block";
        btnleft.style.display = "none";
    };
    btnright.onclick = () => {
        collapseOffNotes();
    };
    btnleft.onclick = () => {
        collapseOnNotes();
    };

    //nouvelle note
    notesnew.onblur = () => {
        noteErr.textContent="";
        noteErr.style.display = "none";

        let texte = notesnew.value.replace(/\n/g, "<br />");
        if(texte.length >0) {

            //ajout du commentaire
            let url = root + "/note/new"; 
            const request = new Request(url, {
                method: 'POST',
                body: JSON.stringify({texte: texte, route:route}),
                headers: { 'Content-Type': 'application/json' },
            });
            fetch(request).then(response => {
                if (200 === response.status) {
                    return response.json();  
                } else {
                    noteErr.textContent="Erreur: " + response.status + " " + response.statusText;
                    noteErr.style.display = "block";
                }
            }).then(note => {
                if(note != null) {
                    let div = getDivNote(note);
                    divnotes.insertBefore(div, noteErr.nextSibling);
                    notesnew.value="";
                }                 
            });
        }      
    }

} //fin window.onload

//pour un ecodage propre de la route (pour les notes)
function fixedEncodeURI(str) {
    return encodeURIComponent(str).replace(/%2F/g, '-');
}

//suppression d'une note
function deleteNote(noteid) { 
    noteErr.textContent="";
    noteErr.style.display = "none";

    if(confirm("Sûr de vouloir supprimer cette note ?")){

        //suppression du commentaire
        let root = location.protocol + '//' + location.host;    
        let url = root + "/note/" + noteid; 
        const request = new Request(url, { method: 'DELETE' });
        fetch(request).then(response => {
            if (200 === response.status) {
                
                let divnote = document.getElementById("note_" + noteid);    
                let divnotes = document.getElementById("sidenotes");
                divnotes.removeChild(divnote);

            } else {
                noteErr.textContent="Erreur: " + response.status + " " + response.statusText;
                noteErr.style.display = "block";    
            }             
        });
    }
}
