<?php

namespace App\Repository;

use App\Entity\Promotion;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Promotion|null find($id, $lockMode = null, $lockVersion = null)
 * @method Promotion|null findOneBy(array $criteria, array $orderBy = null)
 * @method Promotion[]    findAll()
 * @method Promotion[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PromotionRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Promotion::class);
    }

    public function findPromoCurrentForApprenant($apprenantid): ?Promotion
    {
        return $this->createQueryBuilder('p')
            ->leftJoin('p.promoAppres', 'pa')
            ->andWhere('pa.apprenant = :aid')
            ->setParameter('aid', $apprenantid)
            ->orderBy('p.Annee', 'desc')
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
  
}
