<?php

namespace App\Repository;

use App\Entity\Formation;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Formation|null find($id, $lockMode = null, $lockVersion = null)
 * @method Formation|null findOneBy(array $criteria, array $orderBy = null)
 * @method Formation[]    findAll()
 * @method Formation[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class FormationRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Formation::class);
    }

    public function findCurrentForApprenant($apprenantid): ?Formation
    {
        return $this->createQueryBuilder('f')
            ->leftJoin('f.promotions', 'p')
            ->leftJoin('p.promoAppres', 'pa')
            ->andWhere('pa.apprenant = :aid')
            ->setParameter('aid', $apprenantid)
            ->orderBy('p.Annee', 'desc')
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
