<?php

namespace App\Repository;

use App\Entity\Competence;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @method Competence|null find($id, $lockMode = null, $lockVersion = null)
 * @method Competence|null findOneBy(array $criteria, array $orderBy = null)
 * @method Competence[]    findAll()
 * @method Competence[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class CompetenceRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Competence::class);
    }

    public function findByCompetenceForApprenant($promoid, $promoappreid)
    {
        $rawSql = "select c.id as compid, c.intitule as competence, c.activite, ".
                         "e.id as evalid, e.intitule as evaluation, e.date, ".
                         "COALESCE(r.imiter,0) as imiter, COALESCE(r.adapter,0) as adapter, COALESCE(r.transposer,0) as transposer ".
                  "from fa_competence c ".
                  "inner join fa_formation f on f.id=c.formation_id ".
                  "inner join fa_promotion p on p.formation_id=f.id ".
                  "inner join fa_promoappre pa on pa.promotion_id=p.id ".
                  "left join fa_evaluation e on e.promotion_id = p.id ".
                  "left join fa_resultats r on r.evaluation_id = e.id and r.competence_id=c.id and r.promoapprenant_id=pa.id ".
                  "where p.id=? and pa.id=? ". 
                  "order by compid, evalid";

        $stmt = $this->getEntityManager()->getConnection()->prepare($rawSql);
        $stmt->execute([$promoid, $promoappreid]);

        return $stmt->fetchAll();        
    }

    public function findByEvaluationForApprenant($promoid, $promoappreid)
    {
        $rawSql = "select pa.id as promoapprid, e.id as evalid, e.intitule as evaluation, e.date, ".
                  "        c.id as compid, c.intitule as competence, ".     
                  "    case when COALESCE(r.transposer,0) >0 then 3 ".
                  "            when COALESCE(r.adapter,0) >0 then 2 ".
                  "            when COALESCE(r.imiter,0)  >0 then 1 else 0 end as niveau ".
                  "from fa_competence c ". 
                  "inner join fa_formation f on f.id=c.formation_id ". 
                  "inner join fa_promotion p on p.formation_id=f.id ". 
                  "inner join fa_promoappre pa on pa.promotion_id=p.id ". 
                  "left join fa_evaluation e on e.promotion_id = p.id ". 
                  "left join fa_resultats r on r.evaluation_id = e.id and r.competence_id=c.id and r.promoapprenant_id=pa.id ". 
                  "where p.id=? and pa.id=? ". 
                  "order by evalid, compid";

        $stmt = $this->getEntityManager()->getConnection()->prepare($rawSql);
        $stmt->execute([$promoid, $promoappreid]);

        return $stmt->fetchAll();        
    }

}
