<?php

namespace App\Repository;

use App\Entity\Apprenant;

use Doctrine\ORM\QueryBuilder;

use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;

/**
 * @method Apprenant|null find($id, $lockMode = null, $lockVersion = null)
 * @method Apprenant|null findOneBy(array $criteria, array $orderBy = null)
 * @method Apprenant[]    findAll()
 * @method Apprenant[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ApprenantRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Apprenant::class);
    }


    public function findAllByPromoAndNom($nom, $promo)
    {
        $query = $this->createQueryBuilder('a');
        if($promo && strlen($promo)>0) {
            $query =  $query->leftJoin('a.promoAppres', 'pa')
                            ->leftJoin('pa.promotion', 'p')
                            ->andWhere('p.id = :promoid')
                            ->setParameter('promoid', $promo);
            if($nom && strlen($nom)>0) $query =  $query->andWhere("a.Nom like :nom or a.Prenom like :nom")
                                     ->setParameter('nom', $nom.'%');
            return $query->getQuery()->getResult();
        }
        else { 
            //recherche sur le nom seul
            return $this->createQueryBuilder('a')
                ->where('a.Nom like :nom or a.Prenom like :nom')
                ->setParameter('nom', $nom.'%')
                ->getQuery()->getResult();
        }



        
    }
    
}
