<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20200710164138 extends AbstractMigration
{
    public function getDescription() : string
    {
        return '';
    }

    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('CREATE TABLE fa_absence (id INT AUTO_INCREMENT NOT NULL, apprenant_id INT DEFAULT NULL, promotion_id INT DEFAULT NULL, promo_appre_id INT NOT NULL, date_debut DATE NOT NULL, date_fin DATE NOT NULL, justifie VARCHAR(255) NOT NULL, INDEX IDX_135B577BC5697D6D (apprenant_id), INDEX IDX_135B577B139DF194 (promotion_id), INDEX IDX_135B577B401C2F22 (promo_appre_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_user (id INT AUTO_INCREMENT NOT NULL, email VARCHAR(180) NOT NULL, roles JSON NOT NULL, password VARCHAR(255) NOT NULL, username VARCHAR(120) NOT NULL, avatar VARCHAR(255) NOT NULL, discr VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_A0362B11E7927C74 (email), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_apprenant (id INT NOT NULL, offres_id INT DEFAULT NULL, nom VARCHAR(255) NOT NULL, prenom VARCHAR(255) NOT NULL, tel VARCHAR(255) NOT NULL, date_naissance DATE NOT NULL, adresse VARCHAR(255) NOT NULL, ville VARCHAR(255) NOT NULL, git VARCHAR(255) DEFAULT NULL, status VARCHAR(255) NOT NULL, INDEX IDX_471DC93A6C83CD9F (offres_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_competence (id INT AUTO_INCREMENT NOT NULL, formation_id INT DEFAULT NULL, intitule VARCHAR(255) NOT NULL, activite VARCHAR(255) NOT NULL, INDEX IDX_8E8D4A8D5200282E (formation_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_contacts (id INT AUTO_INCREMENT NOT NULL, entreprise_id INT DEFAULT NULL, nom VARCHAR(255) NOT NULL, prenom VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, tel VARCHAR(255) NOT NULL, mobile VARCHAR(255) NOT NULL, INDEX IDX_164AC664A4AEAFEA (entreprise_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_entreprise (id INT AUTO_INCREMENT NOT NULL, nom VARCHAR(255) NOT NULL, adresse VARCHAR(255) NOT NULL, code_postal INT NOT NULL, ville VARCHAR(255) NOT NULL, tel VARCHAR(255) NOT NULL, mobile VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_evaluation (id INT AUTO_INCREMENT NOT NULL, promotion_id INT DEFAULT NULL, intitule VARCHAR(255) NOT NULL, date DATE NOT NULL, description LONGTEXT NOT NULL, INDEX IDX_97A8787139DF194 (promotion_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_formation (id INT AUTO_INCREMENT NOT NULL, intitule VARCHAR(255) NOT NULL, duree VARCHAR(255) NOT NULL, nombre_heure INT NOT NULL, diplome VARCHAR(255) NOT NULL, modalites VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_notes (id INT AUTO_INCREMENT NOT NULL, auteur_id INT NOT NULL, created DATETIME NOT NULL, route VARCHAR(255) NOT NULL, texte LONGTEXT NOT NULL, INDEX IDX_6486DAB760BB6FE6 (auteur_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_offres (id INT AUTO_INCREMENT NOT NULL, entreprise_id INT DEFAULT NULL, intitule VARCHAR(255) NOT NULL, date_debut DATE NOT NULL, date_fin DATE NOT NULL, cahier_des_charges VARCHAR(255) DEFAULT NULL, INDEX IDX_77C2411CA4AEAFEA (entreprise_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_promoappre (id INT AUTO_INCREMENT NOT NULL, promotion_id INT NOT NULL, apprenant_id INT NOT NULL, INDEX IDX_708A1E60139DF194 (promotion_id), INDEX IDX_708A1E60C5697D6D (apprenant_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_promotion (id INT AUTO_INCREMENT NOT NULL, formation_id INT DEFAULT NULL, annee INT NOT NULL, date_debut DATE NOT NULL, date_fin DATE NOT NULL, commentaires VARCHAR(255) DEFAULT NULL, INDEX IDX_42EBF2C55200282E (formation_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_reseau (id INT AUTO_INCREMENT NOT NULL, apprenant_id INT DEFAULT NULL, nom VARCHAR(255) NOT NULL, lien VARCHAR(255) NOT NULL, INDEX IDX_7C8B58E0C5697D6D (apprenant_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_resultats (id INT AUTO_INCREMENT NOT NULL, evaluation_id INT DEFAULT NULL, competence_id INT DEFAULT NULL, promoapprenant_id INT DEFAULT NULL, imiter SMALLINT NOT NULL, adapter SMALLINT NOT NULL, transposer SMALLINT NOT NULL, INDEX IDX_D61B1816456C5646 (evaluation_id), INDEX IDX_D61B181615761DAB (competence_id), INDEX IDX_D61B18164F3364D1 (promoapprenant_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE fa_retard (id INT AUTO_INCREMENT NOT NULL, promo_appre_id INT NOT NULL, date DATE NOT NULL, nombre_heure INT NOT NULL, justifie VARCHAR(255) NOT NULL, INDEX IDX_ED0AA9E5401C2F22 (promo_appre_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE fa_absence ADD CONSTRAINT FK_135B577BC5697D6D FOREIGN KEY (apprenant_id) REFERENCES fa_apprenant (id)');
        $this->addSql('ALTER TABLE fa_absence ADD CONSTRAINT FK_135B577B139DF194 FOREIGN KEY (promotion_id) REFERENCES fa_promotion (id)');
        $this->addSql('ALTER TABLE fa_absence ADD CONSTRAINT FK_135B577B401C2F22 FOREIGN KEY (promo_appre_id) REFERENCES fa_promoappre (id)');
        $this->addSql('ALTER TABLE fa_apprenant ADD CONSTRAINT FK_471DC93A6C83CD9F FOREIGN KEY (offres_id) REFERENCES fa_offres (id)');
        $this->addSql('ALTER TABLE fa_apprenant ADD CONSTRAINT FK_471DC93ABF396750 FOREIGN KEY (id) REFERENCES fa_user (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE fa_competence ADD CONSTRAINT FK_8E8D4A8D5200282E FOREIGN KEY (formation_id) REFERENCES fa_formation (id)');
        $this->addSql('ALTER TABLE fa_contacts ADD CONSTRAINT FK_164AC664A4AEAFEA FOREIGN KEY (entreprise_id) REFERENCES fa_entreprise (id)');
        $this->addSql('ALTER TABLE fa_evaluation ADD CONSTRAINT FK_97A8787139DF194 FOREIGN KEY (promotion_id) REFERENCES fa_promotion (id)');
        $this->addSql('ALTER TABLE fa_notes ADD CONSTRAINT FK_6486DAB760BB6FE6 FOREIGN KEY (auteur_id) REFERENCES fa_user (id)');
        $this->addSql('ALTER TABLE fa_offres ADD CONSTRAINT FK_77C2411CA4AEAFEA FOREIGN KEY (entreprise_id) REFERENCES fa_entreprise (id)');
        $this->addSql('ALTER TABLE fa_promoappre ADD CONSTRAINT FK_708A1E60139DF194 FOREIGN KEY (promotion_id) REFERENCES fa_promotion (id)');
        $this->addSql('ALTER TABLE fa_promoappre ADD CONSTRAINT FK_708A1E60C5697D6D FOREIGN KEY (apprenant_id) REFERENCES fa_apprenant (id)');
        $this->addSql('ALTER TABLE fa_promotion ADD CONSTRAINT FK_42EBF2C55200282E FOREIGN KEY (formation_id) REFERENCES fa_formation (id)');
        $this->addSql('ALTER TABLE fa_reseau ADD CONSTRAINT FK_7C8B58E0C5697D6D FOREIGN KEY (apprenant_id) REFERENCES fa_apprenant (id)');
        $this->addSql('ALTER TABLE fa_resultats ADD CONSTRAINT FK_D61B1816456C5646 FOREIGN KEY (evaluation_id) REFERENCES fa_evaluation (id)');
        $this->addSql('ALTER TABLE fa_resultats ADD CONSTRAINT FK_D61B181615761DAB FOREIGN KEY (competence_id) REFERENCES fa_competence (id)');
        $this->addSql('ALTER TABLE fa_resultats ADD CONSTRAINT FK_D61B18164F3364D1 FOREIGN KEY (promoapprenant_id) REFERENCES fa_promoappre (id)');
        $this->addSql('ALTER TABLE fa_retard ADD CONSTRAINT FK_ED0AA9E5401C2F22 FOREIGN KEY (promo_appre_id) REFERENCES fa_promoappre (id)');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE fa_apprenant DROP FOREIGN KEY FK_471DC93ABF396750');
        $this->addSql('ALTER TABLE fa_notes DROP FOREIGN KEY FK_6486DAB760BB6FE6');
        $this->addSql('ALTER TABLE fa_absence DROP FOREIGN KEY FK_135B577BC5697D6D');
        $this->addSql('ALTER TABLE fa_promoappre DROP FOREIGN KEY FK_708A1E60C5697D6D');
        $this->addSql('ALTER TABLE fa_reseau DROP FOREIGN KEY FK_7C8B58E0C5697D6D');
        $this->addSql('ALTER TABLE fa_resultats DROP FOREIGN KEY FK_D61B181615761DAB');
        $this->addSql('ALTER TABLE fa_contacts DROP FOREIGN KEY FK_164AC664A4AEAFEA');
        $this->addSql('ALTER TABLE fa_offres DROP FOREIGN KEY FK_77C2411CA4AEAFEA');
        $this->addSql('ALTER TABLE fa_resultats DROP FOREIGN KEY FK_D61B1816456C5646');
        $this->addSql('ALTER TABLE fa_competence DROP FOREIGN KEY FK_8E8D4A8D5200282E');
        $this->addSql('ALTER TABLE fa_promotion DROP FOREIGN KEY FK_42EBF2C55200282E');
        $this->addSql('ALTER TABLE fa_apprenant DROP FOREIGN KEY FK_471DC93A6C83CD9F');
        $this->addSql('ALTER TABLE fa_absence DROP FOREIGN KEY FK_135B577B401C2F22');
        $this->addSql('ALTER TABLE fa_resultats DROP FOREIGN KEY FK_D61B18164F3364D1');
        $this->addSql('ALTER TABLE fa_retard DROP FOREIGN KEY FK_ED0AA9E5401C2F22');
        $this->addSql('ALTER TABLE fa_absence DROP FOREIGN KEY FK_135B577B139DF194');
        $this->addSql('ALTER TABLE fa_evaluation DROP FOREIGN KEY FK_97A8787139DF194');
        $this->addSql('ALTER TABLE fa_promoappre DROP FOREIGN KEY FK_708A1E60139DF194');
        $this->addSql('DROP TABLE fa_absence');
        $this->addSql('DROP TABLE fa_user');
        $this->addSql('DROP TABLE fa_apprenant');
        $this->addSql('DROP TABLE fa_competence');
        $this->addSql('DROP TABLE fa_contacts');
        $this->addSql('DROP TABLE fa_entreprise');
        $this->addSql('DROP TABLE fa_evaluation');
        $this->addSql('DROP TABLE fa_formation');
        $this->addSql('DROP TABLE fa_notes');
        $this->addSql('DROP TABLE fa_offres');
        $this->addSql('DROP TABLE fa_promoappre');
        $this->addSql('DROP TABLE fa_promotion');
        $this->addSql('DROP TABLE fa_reseau');
        $this->addSql('DROP TABLE fa_resultats');
        $this->addSql('DROP TABLE fa_retard');
    }
}
