<?php

namespace App\Entity;

use App\Repository\ResultatsRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass=ResultatsRepository::class)
 * @ORM\Table(name="fa_resultats")
 */
class Resultats
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="smallint")
     */
    private $Imiter;

    /**
     * @ORM\Column(type="smallint")
     */
    private $Adapter;

    /**
     * @ORM\Column(type="smallint")
     */
    private $Transposer;

    /**
     * @ORM\ManyToOne(targetEntity=Evaluation::class, inversedBy="resultats")
     */
    private $evaluation;

    /**
     * @ORM\ManyToOne(targetEntity=Competence::class, inversedBy="resultats")
     */
    private $competence;

    /**
     * @ORM\ManyToOne(targetEntity=PromoAppre::class, inversedBy="resultats")
     */
    private $promoapprenant;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getImiter(): ?int
    {
        return $this->Imiter;
    }

    public function setImiter(int $Imiter): self
    {
        $this->Imiter = $Imiter;

        return $this;
    }

    public function getAdapter(): ?int
    {
        return $this->Adapter;
    }

    public function setAdapter(int $Adapter): self
    {
        $this->Adapter = $Adapter;

        return $this;
    }

    public function getTransposer(): ?int
    {
        return $this->Transposer;
    }

    public function setTransposer(int $Transposer): self
    {
        $this->Transposer = $Transposer;

        return $this;
    }

    public function getEvaluation(): ?Evaluation
    {
        return $this->evaluation;
    }

    public function setEvaluation(?Evaluation $evaluation): self
    {
        $this->evaluation = $evaluation;

        return $this;
    }

    public function getCompetence(): ?Competence
    {
        return $this->competence;
    }

    public function setCompetence(?Competence $competence): self
    {
        $this->competence = $competence;

        return $this;
    }

    public function getPromoapprenant(): ?PromoAppre
    {
        return $this->promoapprenant;
    }

    public function setPromoapprenant(?PromoAppre $promoapprenant): self
    {
        $this->promoapprenant = $promoapprenant;

        return $this;
    }
}
