<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\PromotionRepository")
 * @ORM\Table(name="fa_promotion")
 */
class Promotion
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="integer")
     */
    private $Annee;

    /**
     * @ORM\Column(type="date")
     */
    private $DateDebut;

    /**
     * @ORM\Column(type="date")
     */
    private $DateFin;

    
    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     */
    private $Commentaires;

    /**
     * @ORM\ManyToOne(targetEntity="App\Entity\Formation", inversedBy="promotions")
     */
    private $Formation;


    /**
     * @ORM\OneToMany(targetEntity=PromoAppre::class, mappedBy="promotion",  orphanRemoval=true)
     */
    private $promoAppres;

    /**
     * @ORM\OneToMany(targetEntity=Evaluation::class, mappedBy="promotion")
     */
    private $evaluations;

    public function __construct()
    {

        $this->promoAppres = new ArrayCollection();
        $this->evaluations = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getAnnee(): ?int
    {
        return $this->Annee;
    }

    public function setAnnee(int $Annee): self
    {
        $this->Annee = $Annee;

        return $this;
    }

    public function getDateDebut(): ?\DateTimeInterface
    {
        return $this->DateDebut;
    }

    public function setDateDebut(\DateTimeInterface $DateDebut): self
    {
        $this->DateDebut = $DateDebut;

        return $this;
    }

    public function getDateFin(): ?\DateTimeInterface
    {
        return $this->DateFin;
    }

    public function setDateFin(\DateTimeInterface $DateFin): self
    {
        $this->DateFin = $DateFin;

        return $this;
    }



    public function getCommentaires(): ?string
    {
        return $this->Commentaires;
    }

    public function setCommentaires(?string $Commentaires): self
    {
        $this->Commentaires = $Commentaires;

        return $this;
    }

    public function getFormation(): ?Formation
    {
        return $this->Formation;
    }

    public function setFormation(?Formation $Formation): self
    {
        $this->Formation = $Formation;

        return $this;
    }
    

    /**
     * @return Collection|PromoAppre[]
     */
    public function getPromoAppres(): Collection
    {
        return $this->promoAppres;
    }

    public function addPromoAppre(PromoAppre $promoAppre): self
    {
        if (!$this->promoAppres->contains($promoAppre)) {
            $this->promoAppres[] = $promoAppre;
            $promoAppre->setPromotion($this);
        }

        return $this;
    }

    public function removePromoAppre(PromoAppre $promoAppre): self
    {
        if ($this->promoAppres->contains($promoAppre)) {
            $this->promoAppres->removeElement($promoAppre);
            // set the owning side to null (unless already changed)
            if ($promoAppre->getPromotion() === $this) {
                $promoAppre->setPromotion(null);
            }
        }

        return $this;
    }

    public function __toString()
    {
        return (string) $this->Annee.' '.$this->Formation;
    }

    /**
     * @return Collection|Evaluation[]
     */
    public function getEvaluations(): Collection
    {
        return $this->evaluations;
    }

    public function addEvaluation(Evaluation $evaluation): self
    {
        if (!$this->evaluations->contains($evaluation)) {
            $this->evaluations[] = $evaluation;
            $evaluation->setPromotion($this);
        }

        return $this;
    }

    public function removeEvaluation(Evaluation $evaluation): self
    {
        if ($this->evaluations->contains($evaluation)) {
            $this->evaluations->removeElement($evaluation);
            // set the owning side to null (unless already changed)
            if ($evaluation->getPromotion() === $this) {
                $evaluation->setPromotion(null);
            }
        }

        return $this;
    }
    
}
