<?php

namespace App\DataFixtures;

use DateTime;
use Faker\Factory;
use App\Entity\Note;
use App\Entity\User;
use App\Entity\Offres;
use App\Entity\Retard;
use App\Entity\Absence;
use App\Entity\Contacts;
use App\Entity\Apprenant;
use App\Entity\Formation;
use App\Entity\Promotion;
use App\Entity\Resultats;
use App\Entity\Competence;
use App\Entity\Entreprise;
use App\Entity\Evaluation;
use App\Entity\PromoAppre;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class AppFixtures extends Fixture
{
    private $competence1;
    private $competence2;
    private $competence3;
    private $competence4;
    private $competence5;
    private $competence6;
    private $competence7;
    private $competence8;
    private $eval1;
    private $eval2;
    private $eval3;
    private $eval4;

    private $encoder;
    public function __construct(UserPasswordEncoderInterface $encoder)
    {
        $this->encoder = $encoder;
        $this->competence1 = new Competence;
        $this->competence2 = new Competence;
        $this->competence3 = new Competence;
        $this->competence4 = new Competence;
        $this->competence5 = new Competence;
        $this->competence6 = new Competence;
        $this->competence7 = new Competence;
        $this->competence8 = new Competence;
        $this->eval1 = new Evaluation;
        $this->eval2 = new Evaluation;
        $this->eval3 = new Evaluation;
        $this->eval4 = new Evaluation;
    }
    public function load(ObjectManager $manager)
    {
        $faker = \Faker\Factory::create('fr_FR');

        //formation
        $formation = new Formation();
        $formation->setIntitule('Développeur web et web mobile')
            ->setDuree('8 mois')
            ->setNombreHeure(1200)
            ->setDiplome('Bac +2 (niveau 5)')
            ->setModalites($faker->text);
        $manager->persist($formation);

        //compétences
        $activite = '1. Développer la partie front-end d’une application web ou web mobile en intégrant les recommandations de sécurité';
        $this->competence1->setIntitule('1. Maquetter une application')->setActivite($activite)->setFormation($formation);
        $this->competence2->setIntitule('2. Réaliser une interface utilisateur web statique et adaptable')->setActivite($activite)->setFormation($formation);
        $this->competence3->setIntitule('3. Développer une interface utilisateur web dynamique')->setActivite($activite)->setFormation($formation);
        $this->competence4->setIntitule('4. Réaliser une interface utilisateur avec une solution de gestion de contenu ou e-commerce')->setActivite($activite)->setFormation($formation);
        $activite = '2. Développer la partie back-end d’une application web ou web mobile en intégrant les recommandations de sécurité';
        $this->competence5->setIntitule('1. Créer une base de données')->setActivite($activite)->setFormation($formation);
        $this->competence6->setIntitule('2. Développer les composants d’accès aux données')->setActivite($activite)->setFormation($formation);
        $this->competence7->setIntitule('3. Développer la partie back-end d’une application web ou web mobile')->setActivite($activite)->setFormation($formation);
        $this->competence8->setIntitule('4. Elaborer et mettre en œuvre des composants dans une application de gestion de contenu ou e-commerce')->setActivite($activite)->setFormation($formation);
        $manager->persist($this->competence1);
        $manager->persist($this->competence2);
        $manager->persist($this->competence3);
        $manager->persist($this->competence4);
        $manager->persist($this->competence5);
        $manager->persist($this->competence6);
        $manager->persist($this->competence7);
        $manager->persist($this->competence8);        

        //promotion 2019
        $promotion = new Promotion();
        $promotion->setAnnee(2019)
            ->setDateDebut(new DateTime('2019-09-16'))
            ->setDateFin(new DateTime('2020-05-15'))
            ->setFormation($formation)
            ->setCommentaires($faker->text);
        $manager->persist($promotion);

        //évaluations
        $this->eval1
            ->setIntitule('DOJO Maquetter une application')
            ->setPromotion($promotion)
            ->setDate(new DateTime('2019-10-24'))
            ->setDescription('');
        $manager->persist($this->eval1);

        $this->eval2
            ->setIntitule('Bilan Phase 1')
            ->setPromotion($promotion)
            ->setDate(new DateTime('2019-11-04'))
            ->setDescription('');
        $manager->persist($this->eval2);

        $this->eval3
            ->setIntitule('Dojo PHP')
            ->setPromotion($promotion)
            ->setDate(new DateTime('2020-03-30'))
            ->setDescription('');
        $manager->persist($this->eval3);

        $this->eval4
            ->setIntitule('Projet final')
            ->setPromotion($promotion)
            ->setDate(new DateTime('2020-05-07'))
            ->setDescription('');
        $manager->persist($this->eval4);

        //apprenants 2019
        $this->addApprenant($manager, $faker, $promotion, 'AHMAD', 'Alaa', 'https://github.com/AlaaAD86/Simplon', '/2019/alaa.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'AMOS', 'Djimadoumdji Junior', 'https://github.com/AmosConstantJunior', '/2019/junior.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'CESTRIERES ', 'Jean-Marc', 'https://github.com/jmcestrieres', '/2019/jean-marc.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'CHAHID', 'Mohamed Sidi', 'https://github.com/sidi-64ers', '');
        $this->addApprenant($manager, $faker, $promotion, 'GROSSE', 'Gregory', 'https://github.com/Greg981', '/2019/gregory.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'HEDOT', 'Mathieu', 'https://github.com/mathieuh64400', '/2019/mathieuh.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'HOLTERMANN', 'Fréderik', 'https://github.com/F43d3rik/Simplon', '/2019/frederik.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'JOMAA', 'Oussama', 'https://github.com/oussamajomaa', '/2019/oussama.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'LACABANNE', 'Adeline', 'https://github.com/adeline64', '/2019/adeline.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'LEMASSON', 'Wilïam', 'https://github.com/Wiliam64', '/2019/william.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'MORZADEC', 'Marie-Laure', 'https://github.com/mlmsimplon', '/2019/marie-laure.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'NADAL', 'Benoit', 'https://github.com/BenNadal', '/2019/enoit.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'PAVY', 'Mathieu', 'https://github.com/Heyveryouaire', '/2019/mathieup.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'RAMSDEN', 'Clavain', 'https://github.com/clavainova', '/2019/clavain.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'TAVARES', 'Lessandra', 'https://github.com/tavares-lessandra', '/2019/lessandra.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'THOMAIN', 'Pierre', 'https://github.com/THOMAIN-PIERRE', '/2019/pierre.jpg');
        $this->addApprenant($manager, $faker, $promotion, 'VALERO', 'Yoann', 'https://github.com/YoannValero', '/2019/yoann.jpg');

        // //promotion 2018
        // $promotion = new Promotion();
        // $promotion->setAnnee(2018)
        //     ->setDateDebut(new DateTime('2018-09-17'))
        //     ->setDateFin(new DateTime('2019-05-17'))
        //     ->setFormation($formation)
        //     ->setCommentaires($faker->text);

        // //apprenants 2018
        // for ($j = 0; $j < (mt_rand(12, 22)); $j++) {
        //     $apprenant = new Apprenant();
        //     $apprenant->setNom($faker->firstName)
        //         ->setPrenom($faker->LastName)
        //         ->setEmail($faker->email)
        //         ->setPassword($this->encoder->encodePassword($apprenant, 'aaaaaa'));
        //     $apprenant->setTel($faker->mobileNumber)
        //         ->setVille($faker->city)
        //         ->setDateNaissance($faker->dateTimeBetween('-40 years', '-20 years'))
        //         ->setAdresse($faker->streetAddress)
        //         ->setStatus('old');

        //     $manager->persist($apprenant);

        //     $promoAppre = new PromoAppre();
        //     $promoAppre->setPromotion($promotion)
        //         ->setApprenant($apprenant);
        //     $manager->persist($promoAppre);

        //     for ($k = 0; $k < (mt_rand(0, 4)); $k++) {
        //         $retard = new Retard();
        //         $retard->setDate($faker->dateTimeBetween($promotion->getDateDebut(), $promotion->getDateFin()))
        //             ->setNombreHeure(mt_rand(1, 3))
        //             ->setJustifie('oui')
        //             ->setPromoAppre($promoAppre);
        //         $manager->persist($retard);
        //     }

        //     for ($k = 0; $k < (mt_rand(0, 4)); $k++) {
        //         $absence = new Absence();
        //         $absence->setDateDebut($faker->dateTimeBetween($promotion->getDateDebut(), $promotion->getDateFin()))
        //             ->setDateFin($absence->getDateDebut(), '+2 days')
        //             ->setJustifie('oui')
        //             ->setPromoAppre($promoAppre);
        //         $manager->persist($absence);
        //     }
        // }
        // $manager->persist($promotion);


        //Entreprises
        // for ($i = 0; $i < 10; $i++) {
        //     $entreprise = new Entreprise();
        //     $entreprise->setNom($faker->company)
        //         ->setTel($faker->phoneNumber)
        //         ->setMobile($faker->mobileNumber)
        //         ->setEmail($faker->companyEmail)
        //         ->setVille($faker->city)
        //         ->setAdresse($faker->streetAddress)
        //         ->setCodePostal(mt_rand('33000', '90000'));
        //     $manager->persist($entreprise);

        //     for ($j = 0; $j < (mt_rand(3, 7)); $j++) {
        //         $contact = new Contacts();
        //         $contact->setNom($faker->firstName)
        //             ->setPrenom($faker->LastName)
        //             ->setEmail($faker->email)
        //             ->setTel($faker->phoneNumber)
        //             ->setMobile($faker->mobileNumber)
        //             ->setEntreprise($entreprise);
        //         $manager->persist($contact);
        //     }

        //     for ($j = 0; $j < (mt_rand(1, 3)); $j++) {
        //         $offre = new Offres();
        //         $offre->setIntitule('stage')
        //             ->setDateDebut($faker->dateTimeBetween('2019-01-01', '2020-12-31'))
        //             ->setDateFin($faker->dateTimeBetween($promotion->getDateDebut(), '+1 months'))
        //             ->setCahierDesCharges($faker->text)
        //             ->setEntreprise($entreprise);
        //         $manager->persist($offre);
        //     }
        // }

        //utilisateurs
        $user = new User();
        $user->setEmail('nclavere@step-sa.fr')
            ->setUsername('Nadine')
            ->setAvatar('/users/nadine.jpg')
            ->setPassword($this->encoder->encodePassword($user, 'ViveLeCode'))
            ->setRoles(['ROLE_ADMIN']);
        $manager->persist($user);
        $this->addNote($manager, $user, 'Ceci est une note de test de Nadine ...');

        $user = new User();
        $user->setEmail('bfillion@step-sa.fr')
            ->setUsername('Bertrand')
            ->setAvatar('/users/bertrand.jpg')
            ->setPassword($this->encoder->encodePassword($user, 'ViveLePHP'))
            ->setRoles(['ROLE_ADMIN']);
        $manager->persist($user);
        $this->addNote($manager, $user, 'Ceci est une note de test de Bertrand ...');

        $user = new User();
        $user->setEmail('gabbadie@step-sa.fr')
            ->setUsername('Gérald')
            ->setAvatar('/users/gerald.jpg')
            ->setPassword($this->encoder->encodePassword($user, 'ViveLeJS'))
            ->setRoles(['ROLE_ADMIN']);
        $manager->persist($user);
        $this->addNote($manager, $user, "Ceci est une note de test de Gérald, elle est beaucoup plus longue, bien entendu, parce qu'il a beaucoup plus de choses à dire ...");

        //pousse tout en base
        $manager->flush();
    }

    private function addApprenant($manager, $faker, $promotion, $nom, $prenom, $git, $avatar)
    {
        $apprenant = new Apprenant();
        // $apprenant->setNom($nom)
        //     ->setPrenom($prenom)
        //     ->setEmail($faker->email)
        //     ->setPassword($this->encoder->encodePassword($apprenant, 'aaaaaa'));
        // $apprenant->setTel($faker->mobileNumber)
        //     ->setVille($faker->city)
        //     ->setDateNaissance($faker->dateTimeBetween('-40 years', '-20 years'))
        //     ->setAdresse($faker->streetAddress)
        //     ->setGit($git)
        //     ->setAvatar($avatar)
        //     ->setStatus('old');
        $apprenant->setNom($nom)
            ->setPrenom($prenom)
            ->setUsername($prenom.''.$nom)
            ->setEmail($prenom.'.'.$nom.'@faker.com')
            ->setPassword($this->encoder->encodePassword($apprenant, 'ZWcRtBY6hR%2PY}qw'));
        $apprenant->setTel($faker->mobileNumber)
            ->setVille('')
            ->setDateNaissance(new DateTime('1900-01-01'))
            ->setAdresse('')
            ->setGit($git)
            ->setAvatar($avatar)
            ->setStatus('old');
        $manager->persist($apprenant);

        $promoAppre = new PromoAppre();
        $promoAppre->setPromotion($promotion)
            ->setApprenant($apprenant);
        $manager->persist($promoAppre);

        if($prenom=='Alaa') {
            $this->addResultats($manager, $promoAppre, $this->eval1, $this->competence1,0,0,3);
            $this->addResultats($manager, $promoAppre, $this->eval1, $this->competence2,0,0,3);

            $this->addResultats($manager, $promoAppre, $this->eval2, $this->competence1,0,0,3);
            $this->addResultats($manager, $promoAppre, $this->eval2, $this->competence2,0,0,3);
            $this->addResultats($manager, $promoAppre, $this->eval2, $this->competence3,0,0,3);
            $this->addResultats($manager, $promoAppre, $this->eval2, $this->competence6,0,0,3);

            $this->addResultats($manager, $promoAppre, $this->eval3, $this->competence6,0,0,3);
            $this->addResultats($manager, $promoAppre, $this->eval3, $this->competence8,0,0,3);

            $this->addResultats($manager, $promoAppre, $this->eval4, $this->competence1,0,0,3);
            $this->addResultats($manager, $promoAppre, $this->eval4, $this->competence2,0,2,0);
            $this->addResultats($manager, $promoAppre, $this->eval4, $this->competence6,0,2,0);
            $this->addResultats($manager, $promoAppre, $this->eval4, $this->competence7,0,2,0);
        }
    }


    private function addResultats($manager, $promoAppre, $eval, $competence, $imiter, $adapter, $transposer)
    {
        $result = new Resultats();
        $result->setCompetence($competence)
            ->setPromoapprenant($promoAppre)
            ->setEvaluation($eval)
            ->setImiter($imiter)
            ->setAdapter($adapter)
            ->setTransposer($transposer);
        $manager->persist($result);
    }

    private function addNote($manager, $user, $texte)
    {
        $note = new Note();
        $note->setCreated(new DateTime())
             ->setAuteur($user)
             ->setRoute('/editor/apprenant/*/4')
             ->setTexte($texte);
        $manager->persist($note);
    }


}
