<?php

namespace App\Controller;

use App\Entity\Apprenant;
use App\Entity\Resultats;
use App\Form\ResultatsType;
use App\Repository\ResultatsRepository;
use App\Repository\CompetenceRepository;
use App\Repository\EvaluationRepository;
use App\Repository\PromoAppreRepository;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;

/**
 * @Route("/editor/resultats")
 */
class EditResultatsController extends AbstractController
{
    
    /**
     * @Route("/editresults", name="comp_resultats_edit", methods={"POST"})
     */
    public function editresultst(Request $request, PromoAppreRepository $promoAppreRepository, 
                                 EvaluationRepository $evaluationRepository, CompetenceRepository $competenceRepository,
                                 ResultatsRepository $resultatsRepository): Response
    {

        $datas = $request->request->all(); //dd($datas);

        //evaluation
        $evalid = $request->request->get("resultsevalid");
        $eval = $evaluationRepository->find( $evalid );

        //promo apprenant
        $promoapprid = $request->request->get("resultspromoapprid");
        $promoAppr = $promoAppreRepository->find( $promoapprid );

        //suppression des anciens résultats
        $resultatsRepository->deleteEvaluationForApprenant($evalid, $promoapprid);
        
        //compétences
        foreach($datas as $key=>$value) {
            if( $key!="resultsevalid" && $key!="resultspromoapprid" ) {
                $comp = $competenceRepository->find($key);

                $resultat = new Resultats();   
                $resultat->setCompetence($comp); 
                $resultat->setPromoapprenant($promoAppr); 
                $resultat->setEvaluation($eval); 
                $resultat->setImiter($value==1?1:0); 
                $resultat->setAdapter($value==2?2:0); 
                $resultat->setTransposer($value==3?3:0); 
                
                $entityManager = $this->getDoctrine()->getManager();
                $entityManager->persist($resultat);
                $entityManager->flush();
            }
        }

        return $this->redirectToRoute('editor_apprenant_show', ["id" => $promoAppr->getApprenant()->getId() ]);
    }




}
