<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_pluginskel', language 'fr', version '4.0'.
 *
 * @package     tool_pluginskel
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addmore_applicable_formats'] = 'Ajouter plus de formats applicables';
$string['addmore_archetypes'] = 'Ajouter plus d\'archetypes';
$string['addmore_backup_elements'] = 'Ajouter plus d\'éléments de sauvegarde';
$string['addmore_capabilities'] = 'Ajouter plus de capacités';
$string['addmore_cli_scripts'] = 'Ajouter plus de noms de fichiers';
$string['addmore_custom_layouts'] = 'Ajouter plus de mises en pages personnalisées';
$string['addmore_dependencies'] = 'Ajouter plus de dépendances';
$string['addmore_events'] = 'Ajouter plus d\'évenements';
$string['addmore_lang_strings'] = 'Ajouter plus de chaînes de caractères de langue';
$string['addmore_message_providers'] = 'Ajouter plus de fournisseur de messages';
$string['addmore_mobile_addons'] = 'Ajouter plus d\'extension pour mobile';
$string['addmore_observers'] = 'Ajouter plus d\'observateurs';
$string['addmore_params_for_js'] = 'Ajouter plus de paramètres JS';
$string['addmore_parents'] = 'Ajouter plus de parents';
$string['addmore_phpunit_tests'] = 'Ajouter plus de classes de test';
$string['addmore_restore_elements'] = 'Ajouter plus d\'éléments de restauration';
$string['addmore_strings_for_js'] = 'Ajouter plus de chaîne de caractères JS';
$string['addmore_stylesheets'] = 'Ajouter plus de feuilles de style';
$string['atto_features_params_for_js'] = 'Paramètres JS';
$string['atto_features_params_for_js_default'] = 'Défaut';
$string['atto_features_params_for_js_default_help'] = 'La valeur par défaut du paramètre, définie dans le fichier source JavaScript.';
$string['atto_features_params_for_js_name'] = 'Nom';
$string['atto_features_params_for_js_name_help'] = 'Le nom du paramètre.';
$string['atto_features_params_for_js_value'] = 'Valeur';
$string['atto_features_params_for_js_value_help'] = 'La valeur du paramètre JavaScript.';
$string['atto_features_strings_for_js'] = 'Chaîne JS';
$string['atto_features_strings_for_js_id'] = 'Identifiant';
$string['atto_features_strings_for_js_id_help'] = 'L\'identifiant de la chaîne.';
$string['atto_features_strings_for_js_text'] = 'Texte';
$string['atto_features_strings_for_js_text_help'] = 'La valeur de l\'ID de chaîne.';
$string['auth_features_can_be_manually_set'] = 'Peut être réglé manuellement';
$string['auth_features_can_be_manually_set_help'] = 'Vrai si le plugin d\'authentification pourra être défini manuellement pour les utilisateurs.';
$string['auth_features_can_change_password'] = 'Peut changer le mot de passe';
$string['auth_features_can_change_password_help'] = 'Vrai si le plugin d\'authentification peut changer le mot de passe de l\'utilisateur.';
$string['auth_features_can_confirm'] = 'Peut confirmer';
$string['auth_features_can_confirm_help'] = 'Vrai si le plugin d\'authentification permet la confirmation de nouveaux utilisateurs.';
$string['auth_features_can_edit_profile'] = 'Peut éditer son profil';
$string['auth_features_can_edit_profile_help'] = 'Vrai si le plugin d\'authentification peut modifier le profil de l\'utilisateur.';
$string['auth_features_can_reset_password'] = 'Peut re-initialiser le mot de passe';
$string['auth_features_can_reset_password_help'] = 'Vrai si le plugin permet la réinitialisation du mot de passe interne.';
$string['auth_features_can_signup'] = 'Peut s\'inscrire';
$string['auth_features_can_signup_help'] = 'Vrai si le plugin d\'authentification permet l\'inscription et la création d\'utilisateur.';
$string['auth_features_config_ui'] = 'Configuration de l\'interface utilisateur';
$string['auth_features_config_ui_help'] = 'Activer la génération d\'une interface de configuration. Un formulaire Web doit être défini dans la fonction config_form() depuis auth.php.';
$string['auth_features_description'] = 'Description';
$string['auth_features_description_help'] = 'Une courte description d\'une ligne du plugin d\'authentification. Il représente la valeur textuelle de la chaîne de langue "auth_description".';
$string['auth_features_is_internal'] = 'Est interne';
$string['auth_features_is_internal_help'] = 'Vrai si le plugin d\'authentification est "interne". Les plugins internes utilisent des hachages de mot de passe de la table utilisateur Moodle pour l\'authentification.';
$string['auth_features_is_synchronised_with_external'] = 'Est synchronisé avec l\'extérieur';
$string['auth_features_is_synchronised_with_external_help'] = 'Vrai si Moodle doit mettre à jour automatiquement les enregistrements utilisateur internes avec des données provenant de sources externes en utilisant les informations de la méthode get_userinfo().';
$string['auth_features_prevent_local_passwords'] = 'Empêcher les mots de passe locaux';
$string['auth_features_prevent_local_passwords_help'] = 'Vrai si les hachages de mot de passe doivent être stockés dans la base de données Moodle locale.';
$string['back'] = 'Retour';
$string['block_features_applicable_formats'] = 'Formats applicables';
$string['block_features_applicable_formats_allowed'] = 'Autorisé';
$string['block_features_applicable_formats_allowed_help'] = 'Vrai si le plugin de bloc est autorisé sur la page';
$string['block_features_applicable_formats_page'] = 'Page';
$string['block_features_applicable_formats_page_help'] = 'Déclare sur quelle page le plugin est disponible';
$string['block_features_backup_moodle2'] = 'Sauvegarder moodle2';
$string['block_features_backup_moodle2_backup_elements'] = 'Éléments de sauvegarde';
$string['block_features_backup_moodle2_backup_elements_name'] = 'Nom de l\'élément de sauvegarde';
$string['block_features_backup_moodle2_backup_elements_name_help'] = 'Nom de l\'élément de sauvegarde.';
$string['block_features_backup_moodle2_backup_stepslib'] = 'Sauvegarde steplib';
$string['block_features_backup_moodle2_backup_stepslib_help'] = 'Créer un fichier de sauvegarde steplib';
$string['block_features_backup_moodle2_restore_elements'] = 'Restaurer les éléments';
$string['block_features_backup_moodle2_restore_elements_name'] = 'Restaurer le nom de l\'élément';
$string['block_features_backup_moodle2_restore_elements_name_help'] = 'Nom pour l\'élément de restauration.';
$string['block_features_backup_moodle2_restore_elements_path'] = 'Restaurer le chemin de l\'élément';
$string['block_features_backup_moodle2_restore_elements_path_help'] = 'Le chemin de l\'élément de restauration.';
$string['block_features_backup_moodle2_restore_stepslib'] = 'Restaurer stepslib';
$string['block_features_backup_moodle2_restore_stepslib_help'] = 'Créer un fichier de restauration steplib.';
$string['block_features_backup_moodle2_restore_task'] = 'Restaurer la tâche';
$string['block_features_backup_moodle2_restore_task_help'] = 'Créer un fichier de tâche de restauration.';
$string['block_features_backup_moodle2_settingslib'] = 'Settingslib';
$string['block_features_backup_moodle2_settingslib_help'] = 'Créer un fichier settingslib de sauvegarde.';
$string['block_features_edit_form'] = 'Modifier le formulaire';
$string['block_features_edit_form_help'] = 'Créez le fichier edit_form.php qui sera utilisé pour la configuration de l\'instance.';
$string['block_features_instance_allow_multiple'] = 'Autoriser plusieurs instances';
$string['block_features_instance_allow_multiple_help'] = 'Autoriser plusieurs instances du plugin de bloc dans le même cours.';
$string['capabilities'] = 'Capacités';
$string['capabilities_archetypes'] = 'Archétypes';
$string['capabilities_archetypes_permission'] = 'Permission';
$string['capabilities_archetypes_permission_help'] = 'La permission associée au rôle.';
$string['capabilities_archetypes_role'] = 'Rôle';
$string['capabilities_archetypes_role_help'] = 'Archétype standard.';
$string['capabilities_captype'] = 'Captype';
$string['capabilities_captype_help'] = 'Toutes les fonctionnalités sont "lecture" ou "écriture", pour des raisons de sécurité, toutes les fonctionnalités d\'écriture pour les invités et les utilisateurs non connectés sont empêchées.';
$string['capabilities_clonepermissionsfrom'] = 'Cloner les autorisations de';
$string['capabilities_clonepermissionsfrom_help'] = 'Copiez les autorisations pour chaque rôle à partir des paramètres actuels d\'une autre capacité.';
$string['capabilities_contextlevel'] = 'Niveau de contexte';
$string['capabilities_contextlevel_help'] = 'Le niveau de contexte typique où la capacité est vérifiée. C\'est le niveau le plus bas où cette capacité peut être annulée par l\'interface utilisateur des autorisations.';
$string['capabilities_name'] = 'Nom';
$string['capabilities_name_help'] = 'Le nom de la capacité. La capacité "componenttype / componentname: name" sera générée.';
$string['capabilities_riskbitmask'] = 'Riskbit mask';
$string['capabilities_riskbitmask_help'] = 'Le risque associé à la capacité. Les types de risques multiples peuvent être spécifiés en utilisant le "|" séparateur.';
$string['capabilities_title'] = 'Titre';
$string['capabilities_title_help'] = 'Une courte description d\'une ligne sur une ligne. Il représente la valeur du texte pour la chaîne de langue "componentname:name".';
$string['cli_scripts'] = 'Scripts CLI';
$string['cli_scripts_filename'] = 'Nom de fichier';
$string['cli_scripts_filename_help'] = 'Le nom du fichier de script CLI. Tous les fichiers seront générés dans le répertoire "cli" du plugin.';
$string['component'] = 'Composant';
$string['component_help'] = 'Le nom complet du composant frankenstyle sous la forme de componenttype_componentname';
$string['componenthdr'] = 'Composant';
$string['componentname'] = 'Nom du composant';
$string['componentname_help'] = 'Le nom du plugin. Cela deviendra le nom du dossier racine du plugin.

Le nom doit commencer par une lettre et, idéalement, ne contenir que des lettres. Les chiffres et les caractères de soulignement sont autorisés, mais découragés. Les modules d\'activité ne doivent pas comporter de caractères de soulignement dans leur nom.';
$string['componentnameinvalid'] = 'Nom de composant incorrect';
$string['componenttype'] = 'Type de composant';
$string['componenttype_help'] = 'Le type de plugin. Vous trouverez plus d\'informations sur les différents types de plugins dans la documentation officielle de Moodle en cliquant sur le bouton "Plus d\'aide".';
$string['copyright'] = 'Droits d\'auteur';
$string['copyright_desc'] = 'Valeur par défaut du champ Copyright lors de la génération manuelle du squelette du plug-in.';
$string['copyright_help'] = 'Ce champ doit contenir l\'année où le plugin a été créé, le (s) nom (s) du (des) détenteur (s) de copyright ainsi que l\'adresse e-mail (s).

La balise de copyright sera présente dans tous les fichiers du plugin dans le cadre de la norme Moodle.

Pour plus d\'informations sur la plaque standard Moodle, cliquez sur le bouton "Plus d\'aide".';
$string['delete_applicable_formats'] = 'Supprimer le format applicable';
$string['delete_capabilities'] = 'Supprimer la capacité';
$string['delete_cli_scripts'] = 'Supprimer le nom du fichier';
$string['delete_custom_layouts'] = 'Supprimer les mises en page personnalisées';
$string['delete_dependencies'] = 'Supprimer la dépendance';
$string['delete_events'] = 'Supprimer l\'événement';
$string['delete_lang_strings'] = 'Supprimer la chaîne de langue';
$string['delete_message_providers'] = 'Supprimer le fournisseur de message';
$string['delete_mobile_addons'] = 'Supprimer l\'extension mobile';
$string['delete_observers'] = 'Supprimer l\'observateur';
$string['delete_params_for_js'] = 'Supprimer le paramètre JS';
$string['delete_parents'] = 'Supprimer le parent';
$string['delete_phpunit_tests'] = 'Supprimer la classe de test';
$string['delete_restore_elements'] = 'Supprimer l\'élément de restauration';
$string['delete_strings_for_js'] = 'Supprimer la chaîne JS';
$string['delete_stylesheets'] = 'Supprimer la feuille de style';
$string['dependencies'] = 'Dépendances';
$string['dependencies_plugin'] = 'Plugin';
$string['dependencies_plugin_help'] = 'Le nom complet du composant frankenstyle pour la dépendance du plugin.';
$string['dependencies_version'] = 'Version';
$string['dependencies_version_help'] = 'Le numéro de version de la dépendance du plugin.

Une valeur ANY_VERSION signifie que toute version du plugin satisfera la dépendance';
$string['downloadrecipe'] = 'Télécharger la recette';
$string['downloadskel'] = 'Télécharger le squelette du plugin';
$string['emptypluginname'] = 'Nom du plugin non spécifié';
$string['emptyrecipecontent'] = 'Recette vide';
$string['enrol_features_allow_enrol'] = 'Autoriser l\'inscription';
$string['enrol_features_allow_enrol_help'] = 'Autoriser l\'inscription des utilisateurs à partir d\'autres plugins en appelant la fonction enrol_user (). Une capacité "d\'inscription" correspondante doit également être définie.';
$string['enrol_features_allow_manage'] = 'Autoriser la gestion';
$string['enrol_features_allow_manage_help'] = 'Autoriser les autres plugins à modifier manuellement les inscriptions des utilisateurs.';
$string['enrol_features_allow_unenrol'] = 'Autoriser la désinscription';
$string['enrol_features_allow_unenrol_help'] = 'Autoriser les autres plugins à désinscrire tout le monde. Une capacité "unenrol" correspondante doit également être définie.';
$string['enrol_features_allow_unenrol_user'] = 'Autoriser la désinscription de l\'utilisateur';
$string['enrol_features_allow_unenrol_user_help'] = 'Autoriser d\'autres plugins à désinscrire un utilisateur spécifique. Une capacité "unenrol" correspondante doit également être définie.';
$string['events'] = 'Événements';
$string['events_eventname'] = 'Nom de l\'événement';
$string['events_eventname_help'] = 'Le nom de l\'événement créé.';
$string['events_extends'] = 'Étend';
$string['events_extends_help'] = 'Le nom de l\'événement de base que l\'événement étend';
$string['features_install'] = 'Installer';
$string['features_install_help'] = 'Générer le fichier db / install.php';
$string['features_license'] = 'Licence';
$string['features_license_help'] = 'Générer le fichier LICENSE.md avec le texte de la licence GPL3.';
$string['features_readme'] = 'Lisez-moi';
$string['features_readme_help'] = 'Générer le fichier README.md.';
$string['features_settings'] = 'Paramètres';
$string['features_settings_help'] = 'Générer le fichier settings.php.';
$string['features_uninstall'] = 'Désinstaller';
$string['features_uninstall_help'] = 'Générer le fichier db / uninstall.php.';
$string['features_upgrade'] = 'Améliorer';
$string['features_upgrade_help'] = 'Générer le fichier db / upgrade.php.';
$string['features_upgradelib'] = 'Bibliothèque de l\'amélioration';
$string['features_upgradelib_help'] = 'Générer le fichier db / upgradelib.php.';
$string['generalhdr'] = 'Général';
$string['generateskel'] = 'Générer un squelette de plugin';
$string['lang_strings'] = 'Chaîne de langue';
$string['lang_strings_id'] = 'Identifiant';
$string['lang_strings_id_help'] = 'L\'identifiant de la chaîne de langue.';
$string['lang_strings_text'] = 'Texte';
$string['lang_strings_text_help'] = 'La valeur de la chaîne de langue.';
$string['manualhdr'] = 'Générer le plugin manuellement';
$string['maturity'] = 'Maturité';
$string['maturity_help'] = 'La maturité du plugin.';
$string['message_providers'] = 'Fournisseurs de messages';
$string['message_providers_capability'] = 'Capacité requise';
$string['message_providers_capability_help'] = 'La capacité dont l\'utilisateur a besoin pour recevoir le message produit par le fournisseur.';
$string['message_providers_name'] = 'Nom';
$string['message_providers_name_help'] = 'Le nom du fournisseur de message. Le fournisseur de message est défini dans le fichier db / messages.php.';
$string['message_providers_title'] = 'Titre';
$string['message_providers_title_help'] = 'Une courte description d\'une ligne du fournisseur de message. Il représente la valeur du texte pour la chaîne de langue "messageprovider: name".';
$string['mobile_addons'] = 'Extensions pour mobile';
$string['mobile_addons_dependencies'] = 'Dépendances';
$string['mobile_addons_dependencies_name'] = 'Nom';
$string['mobile_addons_dependencies_name_help'] = 'Le nom de la dépendance.';
$string['mobile_addons_name'] = 'Nom';
$string['mobile_addons_name_help'] = 'Le nom de l\'addon distant mobile qui sera chargé lorsque l\'utilisateur accèdera au plugin sur l\'application mobile.';
$string['mod_features_backup_moodle2'] = 'Sauvegarde moodle2';
$string['mod_features_backup_moodle2_backup_elements'] = 'Éléments de sauvegarde';
$string['mod_features_backup_moodle2_backup_elements_name'] = 'Nom de l\'élément de sauvegarde';
$string['mod_features_backup_moodle2_backup_elements_name_help'] = 'Nom de l\'élément de sauvegarde';
$string['mod_features_backup_moodle2_restore_elements'] = 'Restaurer les éléments';
$string['mod_features_backup_moodle2_restore_elements_name'] = 'Restaurer le nom de l\'élément';
$string['mod_features_backup_moodle2_restore_elements_name_help'] = 'Nom pour l\'élément de restauration.';
$string['mod_features_backup_moodle2_restore_elements_path'] = 'Restaurer le chemin de l\'élément';
$string['mod_features_backup_moodle2_restore_elements_path_help'] = 'Le chemin de l\'élément de restauration.';
$string['mod_features_backup_moodle2_settingslib'] = 'Settingslib';
$string['mod_features_backup_moodle2_settingslib_help'] = 'Créer un fichier settingslib de sauvegarde.';
$string['mod_features_file_area'] = 'Zone de fichier';
$string['mod_features_file_area_help'] = 'Génère les fichiers des fonctions liées à l\'API.';
$string['mod_features_gradebook'] = 'Bulletin de notes';
$string['mod_features_gradebook_help'] = 'Vrai si le plugin implémente un carnet de notes.';
$string['mod_features_navigation'] = 'Navigation';
$string['mod_features_navigation_help'] = 'Créez la fonction extend_navigation() et extend_settings_navigation() dans lib.php.';
$string['name'] = 'Nom';
$string['name_help'] = 'Nom lisible par l\'homme pour le plugin. Cela représente la valeur du texte pour la chaîne de langue "pluginname".';
$string['observers'] = 'Observateurs';
$string['observers_callback'] = 'Callback';
$string['observers_callback_help'] = 'Nom de la fonction de rappel.';
$string['observers_eventname'] = 'Nom de l\'événement';
$string['observers_eventname_help'] = 'Nom de classe d\'événement qualifié complet.';
$string['observers_includefile'] = 'Inclure le fichier';
$string['observers_includefile_help'] = 'Fichier à inclure avant d\'appeler l\'observateur. Le chemin du fichier doit être relatif au répertoire racine de Moodle.';
$string['observers_internal'] = 'Interne';
$string['observers_internal_help'] = 'Les observateurs externes ne sont pas appelés lors des transactions avec la base de donnée, mais plutôt après un commit réussi de la transaction.';
$string['observers_priority'] = 'Priorité';
$string['observers_priority_help'] = 'La priorité de l\'observateur. Les observateurs avec une priorité plus élevée sont appelés en premier. S\'il n\'est pas spécifié, il sera par défaut à 0.';
$string['phpunit_tests'] = 'Tests PHPUnit';
$string['phpunit_tests_classname'] = 'Nom de la classe';
$string['phpunit_tests_classname_help'] = 'Le nom de la classe de test. Il peut s\'agir du nom complet du frankenstyle ou du nom de la classe à tester. Tous les fichiers de test PHPUnit seront générés dans le répertoire "tests".';
$string['pluginname'] = 'Générateur de squelette de plugin Moodle';
$string['proceedmanually'] = 'Procéder à la génération manuelle';
$string['proceedrecipe'] = 'Procéder à la recette';
$string['proceedrecipefile'] = 'Procéder avec le fichier de recette';
$string['qtype_features_base_class'] = 'Classe de base';
$string['qtype_features_base_class_help'] = 'Classe de base pour la classe de question située dans question.php.';
$string['recipe'] = 'Recette';
$string['recipe_help'] = 'La recette doit être écrite en utilisant le format de sérialisation YAML. Un modèle de recette se trouve dans le répertoire d\'installation du plugin sur cli / example.yaml.

Plus d\'informations sur la syntaxe YAML peuvent être trouvées en cliquant sur le bouton "Plus d\'aide" qui vous emmènera sur la page web officielle de YAML.';
$string['recipefile'] = 'Fichier de recette';
$string['recipefile_help'] = 'La recette doit être écrite en utilisant le format de sérialisation YAML. Un modèle de recette se trouve dans le répertoire d\'installation du plugin sur cli / example.yaml.

Plus d\'informations sur la syntaxe YAML peuvent être trouvées en cliquant sur le bouton "Plus d\'aide" qui vous emmènera sur la page web officielle de YAML.';
$string['recipefilehdr'] = 'Générer le plugin à partir de la recette';
$string['recipehdr'] = 'Générer le plugin à partir de la recette';
$string['release'] = 'Release';
$string['release_help'] = 'Nom de version lisible par l\'utilisateur qui devrait aider à identifier chaque version du plugin.';
$string['requires'] = 'Version requise de Moodle';
$string['requires_help'] = 'La version minimale de Moodle requise pour l\'installation et le fonctionnement du plugin.';
$string['showrecipe'] = 'Afficher la recette';
$string['showrecipehdr'] = 'Recette';
$string['theme_features_all_layouts'] = 'Toutes les mises en page';
$string['theme_features_all_layouts_help'] = 'Appliquer le thème à toutes les mises en page.';
$string['theme_features_custom_layouts'] = 'Mises en page personnalisées';
$string['theme_features_custom_layouts_name'] = 'Nom de la mise en page personnalisée';
$string['theme_features_custom_layouts_name_help'] = 'Le nom de la mise en page personnalisée que le plugin va créer. La mise en page sera située dans le répertoire "layouts".';
$string['theme_features_doctype'] = 'Doctype';
$string['theme_features_doctype_help'] = 'Le doctype pour la page Web. C\'est habituellement "html5".';
$string['theme_features_parents'] = 'Thèmes parents';
$string['theme_features_parents_base_theme'] = 'Thème de base';
$string['theme_features_parents_base_theme_help'] = 'Le thème de base que ce thème va étendre.';
$string['theme_features_stylesheets'] = 'Feuilles de style';
$string['theme_features_stylesheets_name'] = 'Nom de la feuille de style';
$string['theme_features_stylesheets_name_help'] = 'Le nom de la feuille de style définie par le plugin. La feuille de style sera créée dans le répertoire "styles".';
$string['undefined'] = 'Non défini';
$string['upgradelib'] = 'Upgradelib';
$string['upgradelib_help'] = 'Crée le fichier db/upgradelib.php où le code de la mise à jour peut être groupé dans des fonctions d\'assistances pour être utilisé dans le fichier upgrade.php.';
$string['version'] = 'Version';
$string['version_help'] = 'Le numéro de version du plugin. Le format est partiellement daté avec le format YYYYMMDDXX où XX est un compteur incrémentiel pour l\'année (AAAA), le mois (MM) et la date (DD) de la version du plugin.';
